/******************************************************************************
 *
 * Copyright (c) 1995-2002 PalmSource, Inc. All rights reserved.
 *
 * File: MemoDB.h
 *
 * Release: Palm OS Developer Suite 5 SDK (68K) 4.0
 *
 * Description:
 *		Header for the Memo Manager
 *
 *****************************************************************************/

#ifndef __MEMODB_H__
#define __MEMODB_H__

#ifdef __GNUC__
#include "sections.h"
#endif

#ifndef __GNUC__
#define EXTRA_SECTION_TWO
#endif


#define LocalizedAppInfoStr			1000

typedef struct {
   UInt16	renamedCategories;		// bitfield of categories with a different name
	char	categoryLabels[dmRecNumCategories][dmCategoryLength];
	UInt8	categoryUniqIDs[dmRecNumCategories];
	UInt8	lastUniqID;			// Uniq IDs generated by the device are between
									// 0 - 127.  Those from the PC are 128 - 255.
	UInt8	reserved1;			// from the compiler word aligning things
	UInt16	reserved2;
	UInt16	reserved3;
	UInt8	sortOrder;
	UInt8	reserved;
} MemoAppInfoType;

typedef MemoAppInfoType * MemoAppInfoPtr;


// Sort orders
#define soUnsorted		0
#define soAlphabetic		1


typedef struct {
	char 	note;		// null terminated
	UInt8	reserved;
} MemoDBRecordType;

typedef MemoDBRecordType * MemoDBRecordPtr;

typedef struct {
	Char *				note;
} MemoItemType;

typedef MemoItemType * MemoItemPtr;


#ifdef __cplusplus
extern "C" {
#endif


//-------------------------------------------------------------------
// Routines
//-------------------------------------------------------------------
extern Err		MemoAppInfoInit(DmOpenRef dbP) EXTRA_SECTION_TWO;

extern Err		MemoNewRecord(DmOpenRef dbP, MemoItemPtr item, UInt16 *index) EXTRA_SECTION_TWO;

extern Err		MemoChangeSortOrder(DmOpenRef dbP, UInt8 sortOrder) EXTRA_SECTION_TWO;

extern UInt8	MemoGetSortOrder (DmOpenRef dbP) EXTRA_SECTION_TWO;

extern void		MemoSort (DmOpenRef dbP) EXTRA_SECTION_TWO;

extern Err		MemoSortRecord (DmOpenRef dbP, UInt16 * indexP) EXTRA_SECTION_TWO;

extern Err		MemoGetDatabase (DmOpenRef *dbPP, UInt16 mode) EXTRA_SECTION_TWO;

#ifdef __cplusplus
}
#endif


#endif
